<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained();

            $table->unsignedBigInteger('gift_order_id')->nullable();
            $table->string('gift_amount')->default(0);
            
            $table->string('user_name');
            $table->string('user_email');
            $table->string('user_phone');
            $table->string('services_amount');
            $table->string('total_amount');

            $table->string('status')->default('received');
            $table->string('payment_status')->default('unpaid');

            $table->string('payment_method')->nullable();
            $table->string('transaction_id')->nullable();
            $table->string('transaction_card_name')->nullable();
            $table->string('transaction_card_number')->nullable();
            $table->string('transaction_cvc')->nullable();
            $table->string('transaction_expiry_year')->nullable();
            $table->string('transaction_expiry_month')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
