<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained();
            $table->foreignId('label_id')->constrained();
            $table->unsignedBigInteger('parent_id')->default(0);
            $table->string('name');
            $table->string('image');
            $table->string('price')->nullable();
            $table->string('discounted_price')->nullable();
            $table->string('service_type');
            $table->text('detail');
            $table->text('brief_detail')->nullable();
            $table->text('includes')->nullable();
            $table->text('description')->nullable();
            $table->text('requirements')->nullable();
            $table->text('notes')->nullable();
            $table->text('tags')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
