<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;

    protected $fillable = [
        "parent_id",
        "category_id",
        "label_id",
        "name",
        "image",
        "price",
        "discounted_price",
        "service_type",
        "detail",
        "brief_detail",
        "includes",
        "description",
        "requirements",
        "notes",
        "tags",
        "is_active",
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function label()
    {
        return $this->belongsTo(Label::class);
    }

    public function childService()
    {
        return $this->hasMany(Service::class, 'parent_id', 'id');
    }
}
