<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'gift_order_id',
        'user_name',
        'user_email',
        'user_phone',
        'gift_amount',
        'services_amount',
        'total_amount',
        'status',
        'payment_status',
        'payment_method',
        'transaction_id',
        'transaction_card_name',
        'transaction_card_number',
        'transaction_cvc',
        'transaction_expiry_year',
        'transaction_expiry_month',
    ];

    public function services() {
        return $this->hasMany(OrderHasService::class, 'order_id', 'id');
    }
}
