<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Http\JsonResponse;
use App\Models\Service;

class ServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): JsonResponse
    {
        try {
            $perPage = $request->query('per_page', 10);
            $type = $request->query('type');
            $category = $request->query('category');

            $data = Service::select(
                'id',
                'category_id',
                'image',
                'name',
                'service_type',
                'price',
                'discounted_price',
                'label_id',
            )
                ->with([
                    'label' => function ($query) {
                        $query->select('labels.id', 'labels.name');
                    },
                    'category' => function ($query) {
                        $query->select(
                            'categories.id',
                            'categories.name',
                        )
                            ->where('is_active', 1);
                    },
                ])
                ->where('is_active', 1)
                ->orderBy('id', 'desc');

            if ($category != null) $data = $data->where('category_id', $category);
            if ($type != null) $data = $data->where('service_type', $type);

            $data = $data->paginate($perPage);

            if (empty($data)) return response()->json(['error' => 'No data found.'], 404);
            return response()->json($data, 200);
        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(String $id): JsonResponse
    {
        try {
            $data = Service::with([
                'label' => function ($query) {
                    $query->select('labels.id', 'labels.name');
                },
                'category' => function ($query) {
                    $query->select(
                        'categories.id',
                        'categories.name',
                    )
                        ->where('is_active', 1);
                },
            ])
                ->where('id', $id)
                ->where('is_active', 1)
                ->first();

            if (empty($data)) return response()->json(['error' => 'No data found.'], 404);
            return response()->json($data, 200);
        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
