<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Http\JsonResponse;
use App\Models\Category;

class CategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): JsonResponse
    {
        try {
            $data = Category::select(
                'categories.id',
                'categories.name',
            )
                ->with([
                    'services' => function ($query) {
                        $query->select(
                            'id',
                            'category_id',
                            'image',
                            'name',
                            'service_type',
                            'price',
                            'discounted_price',
                            'label_id',
                        )
                            ->where('is_active', 1);
                    },
                    'services.label' => function ($query) {
                        $query->select('labels.id', 'labels.name');
                    },
                ])
                ->where('is_active', 1)
                ->get();

            if (empty($data)) return response()->json(['error' => 'No data found.'], 404);
            return response()->json($data, 200);
        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(String $id): JsonResponse
    {
        try {
            $data = Category::where('id', $id)->where('is_active', 1)
                ->with([
                    'services' => function ($query) {
                        $query->select(
                            'id',
                            'category_id',
                            'image',
                            'name',
                            'service_type',
                            'price',
                            'discounted_price',
                            'label_id',
                        )
                            ->where('is_active', 1);
                    },
                    'services.label' => function ($query) {
                        $query->select('labels.id', 'labels.name');
                    },
                ])
                ->first();
            if (empty($data)) return response()->json(['error' => 'No data found.'], 404);
            return response()->json($data, 200);
        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
